<?php
define('DIR_ROOT', dirname(__FILE__) . '/../../../../../');
define('AREA', 'A');

require dirname(__FILE__) . '/../../../../../app/functions/fn.common.php';
require dirname(__FILE__) . '/../../../../../app/Tygh/Api/Iformat.php';
require dirname(__FILE__) . '/../../../../../app/Tygh/Api/Formats/Json.php';

use Tygh\Api\Formats\Json;

/**
 * Tests core API functionality via CURL
 */
class Api_Formats_JsonTest extends PHPUnit_Framework_TestCase
{
    protected $_object;

    protected function setUp()
    {
        parent::setUp();

        $this->_object = new Json();
    }

    protected function tearDown()
    {
    }

    /**
     * @dataProvider providerJson()
     */
    public function testEncode($data, $result)
    {
        $this->assertEquals($this->_object->encode($data), $result);
    }

    /**
     * @dataProvider providerJson()
     */
    public function testDecode($result, $data)
    {
        $this->assertEquals($this->_object->decode($data), $result);
    }

    public function providerJson()
    {
        return array(
            array(1, '1'),
            array(array(1, 3, 4), '[1,3,4]'),
            array(array(1, array(1, 3, 'test' => 4), '4'), '[1,{"0":1,"1":3,"test":4},"4"]'),
        );
    }
}
