<?php
namespace Tygh\Api\Entities;

require_once dirname(__FILE__) . '/../../../TestUnitDB.php';

use Tygh\Api\Entities\Langvars;
use Tygh\Api\Response;
/**
 * Tests API entity functionality via CURL
 */
class LangvarsTest extends \TestUnitDB
{
    /**
     * @var \Tygh\Api\Entities\Langvars
     */
    protected $api;

    protected $auth = array(
        'area' => 'A',
        'user_id' => '1',
        'user_type' => 'A',
        'tax_exempt' => 'N',
        'last_login' => '1343637055',
        'usergroup_ids' => array ( ),
        'order_ids' => array ( ),
        'act_as_user' => false,
        'this_login' => 1343652763,
        'password_change_timestamp' => 0,
        'company_id' => 0,
        'is_root' => 'Y',
        'referer' => '',
        'ip' => '192.168.1.111',
        'first_expire_check' => false
    );

    protected function setUp()
    {
        parent::setUp();

        $this->api = new Langvars($this->auth);
    }

    protected function tearDown()
    {
    }

    protected function langVarsDataset()
    {
        return array(
            //'language_values.xml',
        );
    }

    /**
     *
     * @dataProvider providerIndex()
     * @datasetProvider langVarsDataset
     */
    public function testIndex($id, $params, $response_status, $data = array(), $parentResult = array())
    {
        if ($parentResult) {
            $this->api->setParentName('languages');
            $this->api->setParentData($parentResult['data']);
        }

        $result = $this->api->index($id, $params);

        $this->assertEquals($result['status'], $response_status);

        if ($result['status'] == Response::STATUS_OK) {
            $this->assertNotEmpty($result['data']);
        }

        if ($data) {
            $this->assertEquals($result['data'], $data);
        }
    }


    /**
     * @dataProvider providerIndex()
     * @datasetProvider langVarsDataset
     */
    public function providerIndex()
    {
        $parent = new \Tygh\Api\Entities\Languages($this->auth);
        $parentResult = $parent->index(1);

        return array(
            array(
                // Request with empty data
                '', array(), Response::STATUS_OK,
            ),
            array(
                // Request with language name
                'error', array(), Response::STATUS_OK,
            ),
            array(
                // Request with bad language name
                'jhdnlk!!!mk;kjk', array(), Response::STATUS_OK, array('lang_code' => 'en', 'name' => 'jhdnlk!!!mk;kjk', 'value' => '_jhdnlk!!!mk;kjk'),
            ),

            array(
                // Request with parent language code and empty data
                '', array(), Response::STATUS_OK, array(), $parentResult,
            ),
            array(
                // Request with parent language code and language name
                'error', array(), Response::STATUS_OK, array('lang_code' => 'en', 'name' => 'error', 'value' => 'Error'), $parentResult,
            ),
        );
    }

    /**
     *
     * @dataProvider providerCreate()
     * @datasetProvider langVarsDataset
     */
    public function testCreate($params, $response_status, $data = array(), $parentResult = array())
    {
        if ($parentResult) {
            $this->api->setParentName('languages');
            $this->api->setParentData($parentResult['data']);
        }

        $result = $this->api->create($params);

        $this->assertEquals($result['status'], $response_status);

        if ($result['status'] == Response::STATUS_CREATED) {
            $this->assertEquals($result['data']['name'], $params['name']);
        }

        if ($data) {
            $this->assertEquals($result['data'], $data);
        }
    }

    public function providerCreate()
    {
        $parent = new \Tygh\Api\Entities\Languages($this->auth);
        $parentResult = $parent->index(1);

        return array(
            array(
                // Request with empty data
                array(), Response::STATUS_BAD_REQUEST,
            ),
            array(
                // Request with empty name and value
                array('lang_code' => 'en'), Response::STATUS_BAD_REQUEST,
            ),
            array(
                // Request with empty parent language code
                array('name' => 'test', 'value' => 'Test'), Response::STATUS_CREATED, array('name' => 'test'),
            ),
            array(
                // Request with correct data
                array('name' => 'test', 'value' => 'Test'), Response::STATUS_CREATED, array('name' => 'test'), $parentResult,
            ),
        );
    }

    /**
     *
     * @dataProvider providerUpdate()
     * @datasetProvider langVarsDataset
     */
    public function testUpdate($id, $params, $response_status, $data = array(), $parentResult = array())
    {
        if ($parentResult) {
            $this->api->setParentName('languages');
            $this->api->setParentData($parentResult['data']);
        }

        $result = $this->api->update($id, $params);

        $this->assertEquals($result['status'], $response_status);

        if ($result['status'] == Response::STATUS_OK) {
            $this->assertEquals($result['data']['name'], $id);
        }

        if ($data) {
            $this->assertEquals($result['data'], $data);
        }
    }

    public function providerUpdate()
    {
        $parent = new \Tygh\Api\Entities\Languages($this->auth);
        $parentResult = $parent->index(1);

        return array(
            array(
                // Request with empty data
                '', array(), Response::STATUS_BAD_REQUEST,
            ),
            array(
                // Request with empty name and value
                'test', array('lang_code' => 'en'), Response::STATUS_OK, array('name' => 'test'),
            ),
            array(
                // Request with empty parent language code
                'test', array('name' => 'test', 'value' => 'Test'), Response::STATUS_OK,
            ),
            array(
                // Request with empty language variable name (name in params is used to set new data)
                '', array('name' => 'test', 'value' => 'Test'), Response::STATUS_BAD_REQUEST, array(), $parentResult
            ),
            array(
                // Request with correct data
                'test', array('name' => 'test', 'value' => 'Test new'), Response::STATUS_OK, array('name' => 'test'), $parentResult
            ),
        );
    }

    /**
     *
     * @dataProvider providerDelete()
     * @datasetProvider langVarsDataset
     */
    public function testDelete($id, $response_status, $parentResult = array())
    {
        if ($parentResult) {
            $this->api->setParentName('languages');
            $this->api->setParentData($parentResult['data']);
        }

        $result = $this->api->delete($id);

        $this->assertEquals($result['status'], $response_status);
    }

    public function providerDelete()
    {
        $parent = new \Tygh\Api\Entities\Languages($this->auth);
        $parentResult = $parent->index(1);

        return array(
            array(
                // Request with empty data
                '', Response::STATUS_NOT_FOUND,
            ),
            array(
                // Request with correct data
                'test', Response::STATUS_NO_CONTENT,
            ),
            array(
                // Request with correct data (test is already deleted)
                'test', Response::STATUS_NOT_FOUND,
            ),
            array(
                // Request with empty language variable name (name is ignored)
                '', Response::STATUS_NOT_FOUND, $parentResult
            ),
            array(
                // Request with correct data (test is already deleted)
                'test', Response::STATUS_NOT_FOUND, $parentResult
            ),
        );
    }
}
